/* arm.v5t-linux.shlib-init.h
   created from arm.v5t-linux.shlib-init.bin, 14998 (0x3a96) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V5T_LINUX_SHLIB_INIT_SIZE    14998
#define STUB_ARM_V5T_LINUX_SHLIB_INIT_ADLER32 0xff4ca44c
#define STUB_ARM_V5T_LINUX_SHLIB_INIT_CRC32   0x41d462dd

unsigned char stub_arm_v5t_linux_shlib_init[14998] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 252, 20,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,192, 70,255,181,  0,161, 28, 57, 11,104,  1, 32,
/* 0x0040 */  13, 29, 76,104, 24, 64, 27, 26, 45, 27,  0,  3,140,104,  0, 44,
/* 0x0050 */   2,208,100, 25, 36, 24,  8,148,  8,105, 64, 25, 89, 25,131,176,
/* 0x0060 */   0,181, 76,104, 12, 49,  9, 25,  0,240,167,248,  3,  5, 27, 13,
/* 0x0070 */ 228, 24, 16,180,192, 26,  1,180,228, 26,192, 24,155,  8,  8,180,
/* 0x0080 */ 255,247,254,255, 27,  6,137,  8, 27, 14,137,  0, 80, 43, 17,209,
/* 0x0090 */  14,224,  4, 57, 66, 88, 19,  1, 27, 15, 11, 43,  8,209,137,  8,
/* 0x00a0 */  83, 26,137,  0, 18, 14, 27,  2, 18,  6, 27, 10, 26, 67, 66, 80,
/* 0x00b0 */   0, 41,238,209,112, 71,  0,181, 75,121,  8,180,139,121,  8,180,
/* 0x00c0 */  16,180,  1,180,  0,240,167,248, 37, 28,  0,240,167,248, 16,180,
/* 0x00d0 */ 255,247,254,255,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,
/* 0x00e0 */   2, 65,160,227, 24,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,
/* 0x00f0 */   3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,  3,  0,160,225,
/* 0x0100 */   2, 16,131,224,  0, 32,160,227,  7,192,160,225,  2,112,160,227,
/* 0x0110 */  15,120,135,227,  0,  0,  0,239, 12,112,160,225,  4,  0,160,225,
/* 0x0120 */ 240,128,189,232,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,
/* 0x0130 */  14,240,160,225,  1, 48,208,228,  1, 48,194,228,  4, 64,148,224,
/* 0x0140 */  18,  0,  0, 11, 22,  0,  0, 42,  1, 16,160,227, 33,  0,  0,234,
/* 0x0150 */   1, 16, 65,226,  4, 64,148,224, 18,  0,  0, 11,  1, 16,161,224,
/* 0x0160 */   4, 64,148,224, 18,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,
/* 0x0170 */  18,  0,  0, 11, 29,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227,
/* 0x0180 */  49,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,
/* 0x0190 */   3,  0,  0, 10,197, 80,176,225, 64,  0,  0, 42, 52,  0,  0,234,
/* 0x01a0 */   4, 64,148,224, 18,  0,  0, 11, 64,  0,  0, 42,  1, 16,160,227,
/* 0x01b0 */   4, 64,148,224, 18,  0,  0, 11, 64,  0,  0, 42,  4, 64,148,224,
/* 0x01c0 */  18,  0,  0, 11,  1, 16,161,224,  4, 64,148,224, 18,  0,  0, 11,
/* 0x01d0 */  56,  0,  0, 58,  4, 16,129,226, 68,  0,  0,234,  4, 64,148,224,
/* 0x01e0 */  18,  0,  0, 11,  1, 16,161,224,  2, 16,129,226,  5, 12,117,227,
/* 0x01f0 */   1, 16,129, 50,  1, 48,130,224,  1, 48, 83,229,  5, 48,210,231,
/* 0x0200 */   1, 48,194,228,  1, 16, 81,226, 72,  0,  0, 26, 24,  0,  0,234,
/* 0x0210 */ 252, 64, 45,233,  0,112,129,224,  0, 80,224,227,  2, 65,160,227,
/* 0x0220 */  24,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,  3, 32, 66,224,
/* 0x0230 */   0, 32,132,229,  0, 64,160,225,  3,  0,160,225,  2, 16,131,224,
/* 0x0240 */   0, 32,160,227,  7,192,160,225,  2,112,160,227, 15,120,135,227,
/* 0x0250 */   0,  0,  0,239, 12,112,160,225,  4,  0,160,225,240,128,189,232,
/* 0x0260 */   1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,
/* 0x0270 */   1, 48,208,228,  1, 48,194,228,  4, 64,148,224, 18,  0,  0, 11,
/* 0x0280 */  22,  0,  0, 42,  1, 16,160,227, 33,  0,  0,234,  1, 16, 65,226,
/* 0x0290 */   4, 64,148,224, 18,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,
/* 0x02a0 */  18,  0,  0, 11,  1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11,
/* 0x02b0 */  29,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227, 48,  0,  0, 58,
/* 0x02c0 */   1, 80,208,228,  3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,
/* 0x02d0 */ 197, 80,176,225, 50,  0,  0,234,  4, 64,148,224, 18,  0,  0, 11,
/* 0x02e0 */   1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11,  1, 16,177,224,
/* 0x02f0 */  63,  0,  0, 26,  1, 16,160,227,  4, 64,148,224, 18,  0,  0, 11,
/* 0x0300 */   1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11, 56,  0,  0, 58,
/* 0x0310 */   2, 16,129,226,  1, 16,129,226,  5, 12,117,227,  1, 16,129, 50,
/* 0x0320 */   0, 48,210,229,  5, 48,210,231,  1, 48,194,228,  1, 16, 81,226,
/* 0x0330 */  67,  0,  0, 26, 24,  0,  0,234,  0, 16,129,224, 62, 64, 45,233,
/* 0x0340 */   0, 80,224,227,  2, 65,160,227, 33,  0,  0,234, 26,  0,189,232,
/* 0x0350 */   1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,
/* 0x0360 */   3,  0,160,225,  2, 16,131,224,  0, 32,160,227,  7,192,160,225,
/* 0x0370 */   2,112,160,227, 15,120,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0380 */   4,  0,160,225, 48,128,189,232,  4, 64,148,224, 14,240,160, 17,
/* 0x0390 */   1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,
/* 0x03a0 */   1, 16,160,227, 14,192,160,225, 18,  0,  0,235,  1, 16,177,224,
/* 0x03b0 */  18,  0,  0,235, 26,  0,  0, 58, 12,240,160,225,  1, 48,208,228,
/* 0x03c0 */   1, 48,194,228, 18,  0,  0,235, 31,  0,  0, 42, 24,  0,  0,235,
/* 0x03d0 */   3, 48, 81,226,  0, 16,160,227, 43,  0,  0, 58,  1, 80,208,228,
/* 0x03e0 */   3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10, 18,  0,  0,235,
/* 0x03f0 */   1, 16,177,224, 18,  0,  0,235,  1, 16,177,224, 50,  0,  0, 26,
/* 0x0400 */  24,  0,  0,235,  2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,
/* 0x0410 */   5, 48,210,231,  1, 16, 81,226,  1, 48,194,228, 52,  0,  0, 42,
/* 0x0420 */  33,  0,  0,234,  0,192,157,229, 14,  0, 92,227, 44,  0,  0, 26,
/* 0x0430 */  12, 72, 45,233,  0,176,208,229,  6,204,160,227,171,177,160,225,
/* 0x0440 */  28,203,160,225, 13,176,160,225, 58,205,140,226, 12,208, 77,224,
/* 0x0450 */   0,192,147,229,  8, 48,141,229,  4,192,141,229,  0, 32,141,229,
/* 0x0460 */  12, 48,141,226,  0,192,160,227,  4,192,131,228, 11,  0, 83,225,
/* 0x0470 */  15,  0,  0, 26, 12, 48,141,226,  2, 32, 65,226,  0, 16,160,225,
/* 0x0480 */   1,192,209,228,  7,192, 12,226, 18,192,205,229,  1,192,209,228,
/* 0x0490 */  44,  2,160,225, 17,  0,205,229, 15,192, 12,226, 16,192,205,229,
/* 0x04a0 */  16,  0,141,226, 45,  0,  0,235, 11,208,160,225,  0, 48,160,225,
/* 0x04b0 */   3,  0,189,232,  0, 16,145,229,  0, 16,129,224,  0, 32,160,227,
/* 0x04c0 */   7,192,160,225,  2,112,160,227, 15,120,135,227,  0,  0,  0,239,
/* 0x04d0 */  12,112,160,225,  3,  0,160,225,  0,136,189,232, 44,  0,  0,234,
/* 0x04e0 */ 240, 79, 45,233, 48,208, 77,226,  0, 48,141,229,  0, 48,208,229,
/* 0x04f0 */   2, 80,208,229,  1,224,208,229,  0,192,157,229, 20, 48,141,229,
/* 0x0500 */  92, 48,157,229,  0, 64,160,227,  0, 64,140,229,  0, 64,131,229,
/* 0x0510 */  20,192,157,229,  1, 48,208,229,  3, 48,140,224,  3,204,160,227,
/* 0x0520 */  28,195,160,225,  1, 48,160,227, 19,238,160,225, 19, 53,160,225,
/* 0x0530 */ 115,206,140,226,  1, 48, 67,226,  1,224, 78,226,  4,  0,128,226,
/* 0x0540 */   6,192,140,226,  4, 16,141,229, 12, 48,141,229, 16,224,141,229,
/* 0x0550 */   8,  0,141,229, 31,  0,  0,234,  8,  0,157,229,  1, 27,160,227,
/* 0x0560 */ 176, 16,131,225, 12,  0, 84,225,132, 48,160,225,  1, 64,132,226,
/* 0x0570 */  28,  0,  0, 26,  4, 48,157,229,  0, 96,160,227,  2,144,131,224,
/* 0x0580 */   3,224,160,225,  6, 32,160,225,  4, 80,157,229,  9, 48,101,224,
/* 0x0590 */   3,  0, 82,225,  1,224,142,226, 73,  2,  0, 10,  5, 48,210,231,
/* 0x05a0 */   1, 32,130,226,  5,  0, 82,227,  6,100,131,225, 40,  0,  0, 26,
/* 0x05b0 */   0,176,160,227,  1,192,160,227, 11,112,160,225,  0,  0,224,227,
/* 0x05c0 */  44,192,141,229, 24,176,141,229, 28,192,141,229, 32,192,141,229,
/* 0x05d0 */  36,192,141,229, 57,  2,  0,234,255,132,224,227,  8,  0, 80,225,
/* 0x05e0 */  68,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x05f0 */   0,  4,160,225,  6,100,131,225, 12, 16,157,229, 24, 32,157,229,
/* 0x0600 */   1,160, 11,224,  2, 18,160,225,  1, 48,138,224,131, 80,160,225,
/* 0x0610 */   8, 48,157,229,181,192,147,225,160, 53,160,225,156,  3,  4,224,
/* 0x0620 */   4,  0, 86,225,185,  0,  0, 42, 20,  0,157,229,  8, 48, 96,226,
/* 0x0630 */  87, 51,160,225, 16, 16,157,229,  1, 32, 11,224, 18, 48,131,224,
/* 0x0640 */   8,  0,157,229,  6, 44,160,227,147,  2, 34,224, 24, 16,157,229,
/* 0x0650 */   2, 59,108,226,  6,  0, 81,227,195, 50,140,224,230,142,130,226,
/* 0x0660 */ 181, 48,128,225, 12,128,136,226,  4,  0,160,209,  1, 16,160,211,
/* 0x0670 */ 164,  0,  0,218, 44, 32,157,229, 84, 80,157,229, 11, 48, 98,224,
/* 0x0680 */   3,112,213,231,  4,  0,160,225,  1, 16,160,227,135,112,160,225,
/* 0x0690 */   1, 92,  7,226,129,160,160,225,133, 48,136,224, 10, 48,131,224,
/* 0x06a0 */   1,  4, 80,227,  2, 76,131,226,  1,192,129,226,119,  0,  0, 42,
/* 0x06b0 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x06c0 */   6,100,131,225,176, 48,212,225,160, 37,160,225, 12, 16,129,224,
/* 0x06d0 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x06e0 */ 163, 50, 67,224,135,  0,  0, 42,  0,  0, 85,227, 12,  0,160,225,
/* 0x06f0 */ 176, 32,196,225, 10, 16,160,225,140,  0,  0, 10, 12,  0,160,225,
/* 0x0700 */ 164,  0,  0,234,  0,  0, 85,227,176, 48,196,225,  6, 96,108,224,
/* 0x0710 */   0,  0,108,224,164,  0,  0, 10,255,  0, 81,227,168,  0,  0,202,
/* 0x0720 */ 105,  0,  0,234,  1,  4, 80,227,  3, 16,129,224,151,  0,  0, 42,
/* 0x0730 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0740 */   6,100,131,225,180, 48,152,225,160, 37,160,225,147,  2, 12,224,
/* 0x0750 */   2, 43, 99,226, 12,  0, 86,225,163, 82, 67,224,194, 50,131,224,
/* 0x0760 */ 180, 48,136, 49,180, 80,136, 33,  0,  0,108,224,  4, 16,160, 49,
/* 0x0770 */  12,  0,160, 49,  6, 96,108, 32,255,  0, 81,227,129, 64,160,225,
/* 0x0780 */   1, 48,129,226,143,  0,  0,218, 24,192,157,229,255,112,  1,226,
/* 0x0790 */   3,  0, 92,227, 84, 16,157,229,  0, 32,160,211, 11,112,193,231,
/* 0x07a0 */   1,176,139,226, 24, 32,141,213, 57,  2,  0,218, 24, 48,157,229,
/* 0x07b0 */   9,  0, 83,227, 24, 80,157,197,  3, 48, 67,210,  6, 80, 69,194,
/* 0x07c0 */  24, 48,141,213, 24, 80,141,197, 57,  2,  0,234,172, 50, 76,224,
/* 0x07d0 */   0, 32,100,224,  8,192,157,229,  8,  0, 82,225,181, 48,140,225,
/* 0x07e0 */   6, 96,100,224,197,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x07f0 */   1, 48,222,228,  2, 36,160,225,  6,100,131,225,  8,  0,157,229,
/* 0x0800 */  24, 48,157,229,131,112,128,224,  6, 13,135,226,176,192,208,225,
/* 0x0810 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,225,  0,  0, 42,
/* 0x0820 */  24, 32,157,229,  8, 80,157,229,  6,  0, 82,227,  2, 59,108,226,
/* 0x0830 */ 102, 30,133,226,  3, 32,160,195, 32, 80,157,229,  0, 32,160,211,
/* 0x0840 */ 195, 50,140,224, 24, 32,141,229, 28,192,157,229, 44, 32,157,229,
/* 0x0850 */  36, 80,141,229,  4, 16,129,226,  4, 80,160,225, 32,192,141,229,
/* 0x0860 */  28, 32,141,229,176, 48,192,225, 98,  1,  0,234,  2, 32,100,224,
/* 0x0870 */ 172, 50, 76,224,  8,  0, 82,225,176, 48,192,225,  6, 96,100,224,
/* 0x0880 */ 236,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0890 */   2, 36,160,225,  6,100,131,225,102, 95,135,226,176,192,213,225,
/* 0x08a0 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 26,  1,  0, 42,
/* 0x08b0 */   2, 59,108,226,195, 50,140,224,  8,  0, 84,225,176, 48,197,225,
/* 0x08c0 */ 252,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x08d0 */   4, 68,160,225,  6,100,131,225,  8, 80,157,229,129, 48,133,224,
/* 0x08e0 */ 138, 48,131,224, 30, 30,131,226,176,192,209,225,164, 53,160,225,
/* 0x08f0 */ 156,  3,  2,224,  2,  0, 86,225,  6, 96, 98, 32,172, 50, 76, 32,
/* 0x0900 */   4, 80, 98, 32, 50,  1,  0, 42,  2, 59,108,226,195, 50,140,224,
/* 0x0910 */   0,  0, 91,227,176, 48,193,225, 73,  2,  0, 10, 44,192,157,229,
/* 0x0920 */  24, 16,157,229, 84,  0,157,229, 11, 48,108,224,  3,112,208,231,
/* 0x0930 */   6,  0, 81,227, 11, 16,160,195,  9, 16,160,211, 24, 16,141,229,
/* 0x0940 */  11,112,192,231,  2,  0,160,225,  1,176,139,226, 57,  2,  0,234,
/* 0x0950 */   2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,176, 48,197,225,
/* 0x0960 */   6, 96,100,224, 37,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0970 */   1, 48,222,228,  2, 36,160,225,  6,100,131,225, 27, 30,135,226,
/* 0x0980 */ 176,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0990 */  52,  1,  0, 42, 44, 80,157,229,  2, 59,108,226, 28, 32,157,229,
/* 0x09a0 */ 195, 50,140,224, 28, 80,141,229,  4, 80,160,225, 44, 32,141,229,
/* 0x09b0 */ 176, 48,193,225, 90,  1,  0,234,  2, 32,100,224,172, 50, 76,224,
/* 0x09c0 */   8,  0, 82,225,176, 48,193,225,  6, 96,100,224, 63,  1,  0,138,
/* 0x09d0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,
/* 0x09e0 */   6,100,131,225,114, 31,135,226,176,192,209,225,162, 53,160,225,
/* 0x09f0 */ 156,  3,  4,224,  4,  0, 86,225, 78,  1,  0, 42,  2, 59,108,226,
/* 0x0a00 */  32, 32,157,229,195, 50,140,224, 44,  0,157,229, 28,192,157,229,
/* 0x0a10 */   4, 80,160,225, 32,192,141,229, 28,  0,141,229, 49,  1,  0,234,
/* 0x0a20 */ 172, 50, 76,224,176, 48,193,225, 44,192,157,229, 32, 16,141,226,
/* 0x0a30 */  10,  0,145,232,  2, 80,100,224, 28, 32,157,229, 36, 16,141,229,
/* 0x0a40 */  32, 32,141,229, 28,192,141,229, 44, 48,141,229,  6, 96,100,224,
/* 0x0a50 */  24, 32,157,229,  8,  0,157,229,  6,  0, 82,227, 11, 32,160,195,
/* 0x0a60 */   8, 32,160,211,166, 30,128,226, 24, 32,141,229,  8, 16,129,226,
/* 0x0a70 */ 255,116,224,227,  7,  0, 85,225,106,  1,  0,138,  9,  0, 94,225,
/* 0x0a80 */  73,  2,  0, 10,  1, 48,222,228,  5, 84,160,225,  6,100,131,225,
/* 0x0a90 */ 176,192,209,225,165, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0aa0 */ 120,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,195, 50,140,224,
/* 0x0ab0 */   4, 80,130,226,  4,  0,160,225,  3,160,160,227,  0,128,160,227,
/* 0x0ac0 */ 176, 48,193,225,152,  1,  0,234,  5, 32,100,224,172, 50, 76,224,
/* 0x0ad0 */   7,  0, 82,225,  6, 96,100,224,176, 48,193,225,131,  1,  0,138,
/* 0x0ae0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,
/* 0x0af0 */   6,100,131,225,178,192,209,225,162, 53,160,225,156,  3,  4,224,
/* 0x0b00 */   4,  0, 86,225,145,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,
/* 0x0b10 */ 195, 50,140,224, 65, 95,130,226,  4,  0,160,225,  3,160,160,227,
/* 0x0b20 */   8,128,160,227,178, 48,193,225,152,  1,  0,234,172, 50, 76,224,
/* 0x0b30 */ 178, 48,193,225,  6, 96,100,224,  2,  0,100,224,129, 95,129,226,
/* 0x0b40 */   8,160,160,227, 16,128,160,227, 10,112,160,225,  1, 16,160,227,
/* 0x0b50 */   1, 48,129,226,  1,  4, 80,227,129, 64,160,225,  3, 16,129,224,
/* 0x0b60 */ 164,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0b70 */   1, 48,222,228,  6,100,131,225,180, 48,149,225,160, 37,160,225,
/* 0x0b80 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x0b90 */ 163, 50, 67,224,  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,
/* 0x0ba0 */ 180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,  1,112, 87,226,
/* 0x0bb0 */ 154,  1,  0, 26,  1, 32,160,227, 18, 58, 65,224, 24, 80,157,229,
/* 0x0bc0 */   8, 48,131,224,  3,  0, 85,227, 40, 48,141,229, 36,  2,  0,202,
/* 0x0bd0 */   8,192,157,229,  3,  0, 83,227,  3, 48,160,163,131, 51,140,224,
/* 0x0be0 */  54, 94,131,226,  2,112,160,225,  6,128,160,227,  1, 48,135,226,
/* 0x0bf0 */   1,  4, 80,227,135, 64,160,225,  3,112,135,224,203,  1,  0, 42,
/* 0x0c00 */   9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0c10 */   6,100,131,225,180, 48,149,225,160, 37,160,225,147,  2, 12,224,
/* 0x0c20 */   2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,
/* 0x0c30 */   0,  0,108,224,  4,112,160, 49, 12,  0,160, 49,180, 32,133, 49,
/* 0x0c40 */   6, 96,108, 32,180, 48,133, 33,  1,128, 88,226,193,  1,  0, 26,
/* 0x0c50 */  64, 32, 71,226,  3,  0, 82,227,  2, 80,160,209, 30,  2,  0,218,
/* 0x0c60 */ 194, 64,160,225, 13,  0, 82,227,  1, 48,  2,226,  1,112, 68,226,
/* 0x0c70 */   2,192,131,227,  5, 64, 68,194,  8, 32,160,193,237,  1,  0,202,
/* 0x0c80 */  28, 87,160,225,  8, 16,157,229,133, 48,129,224,130, 48, 67,224,
/* 0x0c90 */  85, 78,131,226, 14, 64,132,226,  1,  2,  0,234,  1,  4, 80,227,
/* 0x0ca0 */   1, 32,130,226,245,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225,
/* 0x0cb0 */  73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,160,  0,160,225,
/* 0x0cc0 */   0,  0, 86,225,140,192,160,225,  6, 96, 96, 32,  1,192,140, 35,
/* 0x0cd0 */   4,  0, 82,225,237,  1,  0, 26,  8, 32,157,229, 25, 77,130,226,
/* 0x0ce0 */   4, 64,132,226, 12, 82,160,225,  4,112,160,227,  1,160,160,227,
/* 0x0cf0 */  10,128,160,225,  1,  4, 80,227,136, 16,160,225,  1,192,136,226,
/* 0x0d00 */  12,  2,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0d10 */   1, 48,222,228,  6,100,131,225,177, 48,148,225,160, 37,160,225,
/* 0x0d20 */  12,128,136,224,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,
/* 0x0d30 */ 194, 34,131,224,163, 50, 67,224, 10, 80,133, 33,  1,128,160, 49,
/* 0x0d40 */  12,  0,160, 49,177, 32,132, 49,177, 48,132, 33,  6, 96,108, 32,
/* 0x0d50 */   0,  0,108, 32,  1,112, 87,226,138,160,160,225,  3,  2,  0, 26,
/* 0x0d60 */   1, 80,149,226, 44, 80,141,229, 60,  2,  0, 10, 24, 48,157,229,
/* 0x0d70 */   7, 48,131,226, 24, 48,141,229, 44, 80,157,229, 11,  0, 85,225,
/* 0x0d80 */  73,  2,  0,138, 40,192,157,229, 84, 16,157,229, 11, 48,101,224,
/* 0x0d90 */   2, 32,140,226,  3, 64,129,224, 11,192,129,224,  1, 32, 82,226,
/* 0x0da0 */  88, 80,157,229,  0, 48,160,  3,  1, 48,160, 19,  1,176,139,226,
/* 0x0db0 */   5,  0, 91,225,  0, 48,160, 35,  1, 48,  3, 50,  1,112,212,228,
/* 0x0dc0 */   0,  0, 83,227,  1,112,204,228, 45,  2,  0, 26, 88,192,157,229,
/* 0x0dd0 */  12,  0, 91,225, 60,  0,  0, 58,  1,  4, 80,227, 65,  2,  0, 42,
/* 0x0de0 */   9,  0, 94,225, 73,  2,  0, 10,  1,224,142,226,  4,  0,157,229,
/* 0x0df0 */   0, 16,157,229, 92, 32,157,229, 14, 48, 96,224,  0,  0,160,227,
/* 0x0e00 */   0, 48,129,229,  0,176,130,229, 74,  2,  0,234,  1,  0,160,227,
/* 0x0e10 */  48,208,141,226,240,143,189,232,248, 79, 45,233,  1,192,130,224,
/* 0x0e20 */  40,144,157,229, 44,112,157,229,  1,128,160,225,  9,160,135,224,
/* 0x0e30 */   4,176,128,226,  0, 96,208,229,  1, 80,208,229,  2, 64,208,229,
/* 0x0e40 */   6,224,133,224,  0,112,224,227, 23, 85,224,225, 23, 68,224,225,
/* 0x0e50 */   1, 48,160,227,  1, 32,160,227,  1, 16,160,227,  1,  0,160,227,
/* 0x0e60 */ 255, 95, 45,233,  0, 96,160,227, 28, 96,141,229,  3, 44,160,227,
/* 0x0e70 */  18, 46,160,225, 54, 32,130,226,  7, 44,130,226, 11, 16,160,225,
/* 0x0e80 */   1, 11,160,227,  1,  3,128,227,  4,  0,129,228,  2, 32, 82,226,
/* 0x0e90 */  26,  0,  0,202,  5,  0,136,226,  5,  1,  0,235,  8,  0, 80,225,
/* 0x0ea0 */  30,  0,  0, 26, 36, 48,157,229, 16, 32,157,229,  3, 64, 73,224,
/* 0x0eb0 */   2,  0,  4,224, 44,  0,141,229,  6,  2,128,224,  0, 16,139,226,
/* 0x0ec0 */   9,  1,  0,235, 80,  0,  0, 26, 20, 48,157,229, 24, 32,157,229,
/* 0x0ed0 */   4, 48,  3,224, 28,  0,221,229, 19, 50,160,225,  8, 32, 98,226,
/* 0x0ee0 */  48, 50,131,224,108,160,139,226,131, 48,131,224, 14,172,138,226,
/* 0x0ef0 */   1,  0,160,227,131,164,138,224,  7,  0, 86,227, 69,  0,  0, 58,
/* 0x0f00 */   0, 16,157,229,  1, 80, 89,231,133, 80,160,225,  2, 28,138,226,
/* 0x0f10 */   1, 76,  5,226,132, 16,129,224, 11,  1,  0,235,  1, 48,  0,226,
/* 0x0f20 */  36,  4, 83,225, 71,  0,  0, 26,  1, 12, 80,227, 58,  0,  0, 58,
/* 0x0f30 */  73,  0,  0,234, 10, 16,160,225, 11,  1,  0,235,  1, 12, 80,227,
/* 0x0f40 */  69,  0,  0, 58,  6, 48,160,227, 10,  0, 86,227,  3, 48,160, 51,
/* 0x0f50 */   4,  0, 86,227,  6, 48,160, 49,  3, 96, 70,224,112,  0,  0,234,
/* 0x0f60 */   6, 29,139,226,  8,  1,  0,235, 95,  0,  0, 26,  8, 48,157,229,
/* 0x0f70 */   4, 32,157,229,  0, 16,157,229, 12, 48,141,229,  8, 32,141,229,
/* 0x0f80 */   4, 16,141,229,  7,  0, 86,227,  3, 96,160,227,  0, 96,160, 51,
/* 0x0f90 */ 100,160,139,226,  6,172,138,226,135,  0,  0,234,102, 31,139,226,
/* 0x0fa0 */   8,  1,  0,235,114,  0,  0, 26, 44, 48,157,229, 30, 30,139,226,
/* 0x0fb0 */   6,  2,131,224,  9,  1,  0,235,130,  0,  0, 26,  7,  0, 86,227,
/* 0x0fc0 */  11, 96,160,227,  9, 96,160, 51, 36, 48,157,229,  0, 16,157,229,
/* 0x0fd0 */   3, 64, 73,224,  1,  0, 84,225,253,  0,  0, 58,  1,  0, 89,231,
/* 0x0fe0 */   1,  0,201,228,237,  0,  0,234, 27, 30,139,226,  8,  1,  0,235,
/* 0x0ff0 */   4, 64,157,229,127,  0,  0, 10,114, 31,139,226,  8,  1,  0,235,
/* 0x1000 */   8, 64,157,229,125,  0,  0, 10,  8, 48,157,229, 12, 64,157,229,
/* 0x1010 */  12, 48,141,229,  4, 48,157,229,  8, 48,141,229,  0, 16,157,229,
/* 0x1020 */   0, 64,141,229,  4, 16,141,229,  7,  0, 86,227, 11, 96,160,227,
/* 0x1030 */   8, 96,160, 51,104,160,139,226, 10,172,138,226,  0, 16,138,226,
/* 0x1040 */  10,  1,  0,235,144,  0,  0, 26, 44, 48,157,229,  4, 80,138,226,
/* 0x1050 */   0, 32,160,227,  3, 82,133,224,  8, 64,160,227,156,  0,  0,234,
/* 0x1060 */   2, 16,138,226, 10,  1,  0,235,153,  0,  0, 26, 44, 48,157,229,
/* 0x1070 */  65, 95,138,226,  8, 32,160,227,  3, 82,133,224,  8, 64,160,227,
/* 0x1080 */ 156,  0,  0,234,129, 95,138,226, 16, 32,160,227,  1, 76,160,227,
/* 0x1090 */  52, 32,141,229,  1,  0,160,227,  5, 16,160,225, 11,  1,  0,235,
/* 0x10a0 */   4, 48, 80,224,158,  0,  0, 58, 52, 80,157,229,  3, 80,133,224,
/* 0x10b0 */  52, 80,141,229,  0, 16,157,229,  4,  0, 86,227,225,  0,  0, 42,
/* 0x10c0 */   7, 96,134,226,  4,  0, 85,227,  3, 80,160, 35,133, 83,139,224,
/* 0x10d0 */  54, 94,133,226,  1,  0,160,227, 64, 64,160,227,  5, 16,160,225,
/* 0x10e0 */  11,  1,  0,235,  4, 48, 80,224,175,  0,  0, 58, 44, 48,141,229,
/* 0x10f0 */   4,  0, 83,227,221,  0,  0, 58,163, 64,160,225,  1, 64, 68,226,
/* 0x1100 */   1, 16,  3,226,  2, 16,129,227, 14,  0, 83,227,194,  0,  0, 42,
/* 0x1110 */  17, 20,160,225, 94,160,139,226,  3, 48, 65,224,  5,172,138,226,
/* 0x1120 */ 131,160,138,224,206,  0,  0,234,  4, 64, 68,226,255,  0,  0,235,
/* 0x1130 */ 167,112,160,225,  7,  0, 92,225,  7,192, 76, 32,  1, 16,161,224,
/* 0x1140 */   1, 64, 84,226,195,  0,  0, 26, 68,160,139,226,  6,172,138,226,
/* 0x1150 */   1, 18,160,225,  4, 64,160,227,  0, 16,141,229,  1, 80,160,227,
/* 0x1160 */   1,  0,160,227, 10, 16,160,225, 11,  1,  0,235,  1,  0, 16,227,
/* 0x1170 */ 216,  0,  0, 10,  0, 16,157,229,  5, 16,129,225,  0, 16,141,229,
/* 0x1180 */ 133, 80,160,225,  1, 64, 84,226,209,  0,  0, 26,  0, 16,157,229,
/* 0x1190 */ 222,  0,  0,234, 44, 16,157,229,  1, 16,145,226,  0, 16,141,229,
/* 0x11a0 */  52, 80,157,229, 36, 48,157,229,  2, 80,133,226,  3, 48, 73,224,
/* 0x11b0 */   3,  0, 81,225,253,  0,  0,138, 40, 32,157,229,  1,  0, 89,231,
/* 0x11c0 */   1,  0,201,228,  2,  0, 89,225,241,  0,  0, 42,  1, 80, 85,226,
/* 0x11d0 */ 231,  0,  0, 26, 28,  0,205,229, 40, 32,157,229,  2,  0, 89,225,
/* 0x11e0 */  33,  0,  0, 58,255,  0,  0,235,  0,  0,160,227, 32, 32,157,229,
/* 0x11f0 */   2, 48, 72,224, 56, 32,157,229,  0, 48,130,229, 36, 32,157,229,
/* 0x1200 */   2, 48, 73,224,104, 32,157,229,  0, 48,130,229, 60,208,141,226,
/* 0x1210 */ 240,143,189,232,  1,  0,160,227,243,  0,  0,234,  1,  4, 87,227,
/* 0x1220 */  14,240,160, 33, 48, 48,157,229,  7,116,160,225,  8,  0, 83,225,
/* 0x1230 */ 253,  0,  0, 10,  1, 48,216,228, 12,196,131,225, 14,240,160,225,
/* 0x1240 */   6,  0,160,225,128, 16,129,224,  0,  0,160,227,128, 16,129,224,
/* 0x1250 */   1,  4, 87,227, 14, 32,160,225,  1,  1,  0, 59,176, 48,209,225,
/* 0x1260 */ 167,229,160,225,147, 14, 14,224, 14,  0, 92,225, 14,112,160, 49,
/* 0x1270 */  14,112, 71, 32,  2,235, 99, 50, 14,192, 76, 32,174, 50,131, 48,
/* 0x1280 */ 163, 50, 67, 32,  0,  0,176,224,176, 48,193,225,  2,240,160,225,
/* 0x1290 */  30, 32,160,227, 20, 16,143,226,  2,  0,160,227,  4,112,160,227,
/* 0x12a0 */   0,  0,  0,239,127,  0,160,227,  1,112,160,227,  0,  0,  0,239,
/* 0x12b0 */  80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80, 82, 79, 84, 95, 87,
/* 0x12c0 */  82, 73, 84, 69, 32,102, 97,105,108,101,100, 46, 10,  0,  0,  0,
/* 0x12d0 */ 115, 70,  1, 59,  8,180,  3,171,  8,180,  1,180, 32,180,  2,180,
/* 0x12e0 */   3, 35, 11, 64,  3, 53,237, 24,173,  8, 11,155, 90, 25,  4,155,
/* 0x12f0 */   0,240,179,248, 82, 25, 10,155,  0,240,179,248, 82, 25,  0,  0,
/* 0x1300 */   0,240,113,248,  0, 36,228, 67, 50, 35,  3, 34, 13,153, 12,152,
/* 0x1310 */   6, 28,192, 39,  0,223,176, 66,  0,208,  1,222, 11,157, 15,153,
/* 0x1320 */   0,240, 85,248, 31,188,160, 71,  8,188,  3,188,  1, 35,  3,180,
/* 0x1330 */  64, 24,  1, 48,152, 67, 10, 75,  3, 96,  1, 48, 11,144, 63,188,
/* 0x1340 */  27, 66,  0,208,160, 71,  0,152,  1,153,  9, 24,  0,240,107,248,
/* 0x1350 */  11,188,158, 70,  5, 34,125, 39,  0,223, 91, 39,  3,189,  0,  0,
/* 0x1360 */   0,223,255,189,137,  8,137,  0,  0,181, 11, 28,  0,240,179,248,
/* 0x1370 */   8,188,158, 70, 11,104,  4, 49,  3, 96,  4, 48,  1, 61,  7, 35,
/* 0x1380 */  29, 66,247,209,237,  8, 15,208,120, 71,192, 70,212,  3, 45,233,
/* 0x1390 */ 220, 19,177,232,  1, 80, 85,226,220, 19,160,232, 46,  0,  0, 26,
/* 0x13a0 */ 212,  3,189,232, 30,255, 47,225,112, 71,  0, 34, 15, 39, 63,  4,
/* 0x13b0 */   2, 55,  0,223,112, 71,115, 70,  1, 59,  8,180,  0,240,179,248,
/* 0x13c0 */  82, 25,145,  0,  0, 36,228, 67, 34, 35,  7, 34, 17,145,  0, 32,
/* 0x13d0 */ 192, 39,  0,223,  3, 19,  1, 51,  0,209,  1,222, 16,144, 13,153,
/* 0x13e0 */  12,157,  0,240, 85,248,  1,153,  2,157,  3, 35, 11, 64,201, 26,
/* 0x13f0 */ 237, 24, 27, 24,  1,147,  3, 53,173,  8,  0,240, 85,248,  2, 28,
/* 0x1400 */   5,153,  5,144,  0,240, 72,248, 67, 28, 11,153, 11,147,  0,240,
/* 0x1410 */  72,248,  2,188, 71, 28,  0,240, 72,248,  1, 28, 16, 28,190, 70,
/* 0x1420 */ 195,231,204,120,139,120, 36,  2, 28, 67, 75,120, 36,  2, 28, 67,
/* 0x1430 */  11,120, 36,  2, 28, 67,  4, 49,112, 71,155,  8,155,  0,  4, 59,
/* 0x1440 */  29,136,109,  5,173, 10, 91,136, 91,  5, 91, 13,237, 24,  2, 53,
/* 0x1450 */ 109,  8,112, 71,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x1460 */ 101,108,102, 51, 50, 45,108,105,116,116,108,101, 97,114,109, 10,
/* 0x1470 */  10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78,
/* 0x1480 */  97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,
/* 0x1490 */ 101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32,
/* 0x14a0 */  32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,
/* 0x14b0 */ 111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115,
/* 0x14c0 */  10, 32, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32,
/* 0x14d0 */  32, 32, 32, 48, 97, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x14e0 */  52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x14f0 */  83, 10, 32, 32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32,
/* 0x1500 */  32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 52,
/* 0x1510 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1520 */  10, 32, 32, 50, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32,
/* 0x1530 */  32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 52, 32,
/* 0x1540 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1550 */  32, 32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1560 */  32, 32, 48, 49, 51, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48,100,
/* 0x1570 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1580 */  83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32,
/* 0x1590 */  32, 32, 32, 32, 48, 49, 50, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x15a0 */  48, 50, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x15b0 */  69, 78, 84, 83, 10, 32, 32, 53, 32, 78, 82, 86, 50, 66, 32, 32,
/* 0x15c0 */  32, 32, 32, 32, 32, 32, 32, 48,101, 99, 32, 32, 48, 32, 32, 48,
/* 0x15d0 */  32, 32, 48, 51, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x15e0 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95,
/* 0x15f0 */  69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 98, 99, 32, 32, 48, 32,
/* 0x1600 */  32, 48, 32, 32, 48, 52, 50, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1610 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77,
/* 0x1620 */  65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 57, 51, 56, 32,
/* 0x1630 */  32, 48, 32, 32, 48, 32, 32, 48, 52,101, 48, 32, 32, 50, 42, 42,
/* 0x1640 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32,
/* 0x1650 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 52,
/* 0x1660 */  55, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 49, 56, 32, 32,
/* 0x1670 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1680 */  32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32,
/* 0x1690 */  32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50, 57, 48, 32,
/* 0x16a0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x16b0 */  32, 49, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32,
/* 0x16c0 */  32, 32, 48, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50,
/* 0x16d0 */  57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x16e0 */  84, 83, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x16f0 */  32, 32, 32, 32, 32, 48, 49, 56, 52, 32, 32, 48, 32, 32, 48, 32,
/* 0x1700 */  32, 48, 49, 50,100, 48, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79,
/* 0x1710 */  78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65,
/* 0x1720 */  66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 56, 50, 32,108, 32,
/* 0x1730 */  32, 32, 32, 32, 70, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48,
/* 0x1740 */  32, 76, 54, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1750 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78,
/* 0x1760 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1770 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82,
/* 0x1780 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1790 */  32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86,
/* 0x17a0 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x17b0 */  32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48,
/* 0x17c0 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48,
/* 0x17d0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x17e0 */  65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x17f0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1800 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x1810 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x1820 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x1830 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1840 */  78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1850 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 46,
/* 0x1860 */ 114,101, 97,108, 95,115,116, 97,114,116, 95,111,102, 69, 76, 70,
/* 0x1870 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1880 */  32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32,
/* 0x1890 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x18a0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95,
/* 0x18b0 */  72, 69, 65, 68, 32, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10,
/* 0x18c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x18d0 */  32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 48, 32, 78, 82, 86, 95,
/* 0x18e0 */  84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x18f0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x1900 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x1910 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x1920 */  76, 70, 77, 65, 73, 78, 89, 32, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1930 */  78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1940 */  32, 32, 70, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 95,
/* 0x1950 */ 115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x1960 */  32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69, 32, 48, 49, 51,
/* 0x1970 */  99, 32,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,
/* 0x1980 */ 109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1990 */  48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 68, 32,
/* 0x19a0 */  48, 49, 50, 56, 32,117, 99,108, 95,110,114,118, 50,100, 95,100,
/* 0x19b0 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x19c0 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86,
/* 0x19d0 */  50, 66, 32, 48,101, 99, 32,117, 99,108, 95,110,114,118, 50, 98,
/* 0x19e0 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x1a00 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76,122,109, 97,
/* 0x1a10 */  68,101, 99,111,100,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1a20 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,
/* 0x1a30 */  32, 48, 32,101,110,100, 95,100,101, 99,111,109,112,114,101,115,
/* 0x1a40 */ 115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x1a50 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65,
/* 0x1a60 */  73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x1a70 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1a80 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 51, 52, 32,
/* 0x1a90 */  82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67, 65, 76, 76, 32, 32,
/* 0x1aa0 */  32, 32, 46,114,101, 97,108, 95,115,116, 97,114,116, 95,111,102,
/* 0x1ab0 */  69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x1ac0 */  99, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67, 65, 76, 76,
/* 0x1ad0 */  32, 32, 32, 32, 76, 54, 49, 48, 10, 48, 48, 48, 48, 48, 48, 57,
/* 0x1ae0 */  48, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67, 65, 76, 76,
/* 0x1af0 */  32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,114,116, 95,
/* 0x1b00 */ 111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x1b10 */  48, 57, 54, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67, 65,
/* 0x1b20 */  76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,114,
/* 0x1b30 */ 116, 95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48,
/* 0x1b40 */  48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95,
/* 0x1b50 */  67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116,
/* 0x1b60 */  97,114,116, 95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10, 10,
/* 0x1b70 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x1b80 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10,
/* 0x1b90 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x1ba0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x1bb0 */  10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1bc0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1bd0 */  69, 10, 48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77,
/* 0x1be0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1bf0 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82,
/* 0x1c00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1c10 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65,
/* 0x1c20 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1c30 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95,
/* 0x1c40 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c50 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82,
/* 0x1c60 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c70 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32,
/* 0x1c80 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1c90 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97, 48,
/* 0x1ca0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1cb0 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x1cc0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1cd0 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1ce0 */  98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1cf0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1d00 */  48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1d10 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1d20 */  48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1d30 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1d40 */  48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1d50 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1d60 */  48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1d70 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1d80 */  48, 48, 48, 48, 48,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1d90 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1da0 */  48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1db0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1dc0 */  10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x1dd0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1de0 */  69, 10, 48, 48, 48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77,
/* 0x1df0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1e00 */  50, 69, 10, 48, 48, 48, 48, 48, 48,102, 99, 32, 82, 95, 65, 82,
/* 0x1e10 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1e20 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82, 95, 65,
/* 0x1e30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1e40 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95,
/* 0x1e50 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e60 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 51, 52, 32, 82,
/* 0x1e70 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e80 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 51, 56, 32,
/* 0x1e90 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1ea0 */  32, 32, 78, 82, 86, 50, 69, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1eb0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1ec0 */  91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1ed0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ee0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1ef0 */  49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1f00 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x1f10 */  48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1f20 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x1f30 */  48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1f40 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x1f50 */  48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1f60 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x1f70 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1f80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x1f90 */  48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1fa0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x1fb0 */  48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1fc0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x1fd0 */  10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1fe0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1ff0 */  68, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77,
/* 0x2000 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2010 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82,
/* 0x2020 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2030 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65,
/* 0x2040 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2050 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95,
/* 0x2060 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2070 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82,
/* 0x2080 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2090 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,101, 48, 32,
/* 0x20a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x20b0 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,101, 99,
/* 0x20c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x20d0 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,102,
/* 0x20e0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x20f0 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2100 */ 102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2110 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x2120 */  49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2130 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x2140 */  48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2150 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 10, 82, 69,
/* 0x2160 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2170 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70,
/* 0x2180 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2190 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x21a0 */  48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x21b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x21c0 */  48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x21d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x21e0 */  10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x21f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2200 */  66, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 65, 82, 77,
/* 0x2210 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2220 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82,
/* 0x2230 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2240 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65,
/* 0x2250 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2260 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95,
/* 0x2270 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2280 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82,
/* 0x2290 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x22a0 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32,
/* 0x22b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x22c0 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 52,
/* 0x22d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x22e0 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98,
/* 0x22f0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2300 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x2310 */  99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2320 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x2330 */  48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2340 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x2350 */  48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2360 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x2370 */  48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2380 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 10, 82,
/* 0x2390 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x23a0 */  83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x23b0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x23c0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x23d0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95,
/* 0x23e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x23f0 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x2400 */  48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x2420 */  10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2430 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2440 */  95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32,
/* 0x2450 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2460 */  32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 10, 82, 69,
/* 0x2470 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2480 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2490 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x24a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x24b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65,
/* 0x24c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x24d0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x24e0 */  57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x24f0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2500 */  48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2510 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2520 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82,
/* 0x2530 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2540 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2550 */  48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2560 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2570 */  48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77,
/* 0x2580 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2590 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56,
/* 0x25a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x25b0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x25c0 */  48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x25d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x25e0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65,
/* 0x25f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2600 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x2610 */  99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2620 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2630 */  48, 48, 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2640 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2650 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82,
/* 0x2660 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2670 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2680 */  48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2690 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x26a0 */  48, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77,
/* 0x26b0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x26c0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52,
/* 0x26d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x26e0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x26f0 */  48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2700 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2710 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65,
/* 0x2720 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2730 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x2740 */  52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2750 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2760 */  48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2770 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2780 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82,
/* 0x2790 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x27a0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x27b0 */  48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x27c0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x27d0 */  48, 10, 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77,
/* 0x27e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x27f0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52,
/* 0x2800 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2810 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2820 */  48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2830 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2840 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65,
/* 0x2850 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2860 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x2870 */  56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2880 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2890 */  48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x28a0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x28b0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82,
/* 0x28c0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x28d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x28e0 */  48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x28f0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2900 */  48, 10, 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77,
/* 0x2910 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2920 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 56,
/* 0x2930 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2940 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2950 */  48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2960 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2970 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65,
/* 0x2980 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2990 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x29a0 */  54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x29b0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x29c0 */  48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x29d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x29e0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82,
/* 0x29f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a00 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2a10 */  48, 52, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2a20 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2a30 */  48, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77,
/* 0x2a40 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2a50 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,101, 99,
/* 0x2a60 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2a70 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2a80 */  48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2a90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2aa0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65,
/* 0x2ab0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2ac0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,
/* 0x2ad0 */  51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ae0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2af0 */  48, 48, 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2b00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2b10 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82,
/* 0x2b20 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b30 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2b40 */  48, 53, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2b50 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2b60 */  48, 10, 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x2b70 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2b80 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,102, 99,
/* 0x2b90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2ba0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2bb0 */  48, 48, 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2bc0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2bd0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65,
/* 0x2be0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2bf0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x2c00 */  52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2c10 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2c20 */  48, 48, 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2c30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2c40 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82,
/* 0x2c50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c60 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2c70 */  48, 54,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2c80 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2c90 */  48, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77,
/* 0x2ca0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2cb0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99,
/* 0x2cc0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2cd0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2ce0 */  48, 48, 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2cf0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2d00 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65,
/* 0x2d10 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2d20 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x2d30 */  55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2d40 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2d50 */  48, 48, 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2d60 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2d70 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82,
/* 0x2d80 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2d90 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2da0 */  48, 55, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2db0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2dc0 */  48, 10, 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77,
/* 0x2dd0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2de0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,102, 52,
/* 0x2df0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2e00 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2e10 */  48, 48, 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2e20 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2e30 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65,
/* 0x2e40 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2e50 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x2e60 */  55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2e70 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2e80 */  48, 48, 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2e90 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2ea0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82,
/* 0x2eb0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ec0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2ed0 */  48, 56,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2ee0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2ef0 */  48, 10, 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77,
/* 0x2f00 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2f10 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 99,
/* 0x2f20 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2f30 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2f40 */  48, 48, 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2f50 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2f60 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65,
/* 0x2f70 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2f80 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x2f90 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x2fa0 */  82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 93, 58, 10,
/* 0x2fb0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x2fc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x2fd0 */  10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2fe0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2ff0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32,
/* 0x3000 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3010 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3020 */  48, 48, 48, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3030 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3040 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82,
/* 0x3050 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3060 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x3070 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3080 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3090 */  48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x30a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x30b0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95,
/* 0x30c0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x30d0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x30e0 */  49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x30f0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3100 */  10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3110 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3120 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 49, 56, 32,
/* 0x3130 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3140 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3150 */  48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3160 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3170 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82,
/* 0x3180 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3190 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52,
/* 0x31a0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x31b0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x31c0 */  48, 48, 48, 48, 49, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x31d0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x31e0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 53, 48, 32, 82, 95,
/* 0x31f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3200 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3210 */  49, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3220 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3230 */  10, 48, 48, 48, 48, 48, 49, 56, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x3240 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3250 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 99, 32,
/* 0x3260 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3270 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3280 */  48, 48, 49, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3290 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x32a0 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82, 95, 65, 82,
/* 0x32b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x32c0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99,
/* 0x32d0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x32e0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x32f0 */  48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3300 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3310 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 52, 32, 82, 95,
/* 0x3320 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3330 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3340 */  49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3350 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3360 */  10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3370 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3380 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,101, 99, 32,
/* 0x3390 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x33a0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x33b0 */  48, 48, 50, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x33c0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x33d0 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 65, 82,
/* 0x33e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x33f0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52,
/* 0x3400 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3410 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3420 */  48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3430 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3440 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 53, 48, 32, 82, 95,
/* 0x3450 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3460 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3470 */  50, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3480 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3490 */  10, 48, 48, 48, 48, 48, 50, 56, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x34a0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x34b0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 56, 99, 32,
/* 0x34c0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x34d0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x34e0 */  48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x34f0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3500 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65, 82,
/* 0x3510 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3520 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,100,
/* 0x3530 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3540 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3550 */  48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3560 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3570 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,102, 52, 32, 82, 95,
/* 0x3580 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3590 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x35a0 */  51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x35b0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x35c0 */  10, 48, 48, 48, 48, 48, 51, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x35d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x35e0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 50, 99, 32,
/* 0x35f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3600 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3610 */  48, 48, 51, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3620 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3630 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 56, 32, 82, 95, 65, 82,
/* 0x3640 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3650 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 55,
/* 0x3660 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3670 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3680 */  48, 48, 48, 48, 51, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3690 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x36a0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 57, 99, 32, 82, 95,
/* 0x36b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x36c0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x36d0 */  51, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x36e0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x36f0 */  10, 48, 48, 48, 48, 48, 51, 98, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x3700 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3710 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 56, 32,
/* 0x3720 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3730 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3740 */  48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3750 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3760 */  49, 48, 10, 48, 48, 48, 48, 48, 52, 48, 48, 32, 82, 95, 65, 82,
/* 0x3770 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3780 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 49,
/* 0x3790 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x37a0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x37b0 */  48, 48, 48, 48, 52, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x37c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x37d0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x37e0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76,
/* 0x37f0 */  70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x3800 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3810 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x3820 */  50, 48, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67, 65, 76,
/* 0x3830 */  76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,114,116,
/* 0x3840 */  95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48,
/* 0x3850 */  48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67,
/* 0x3860 */  65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,
/* 0x3870 */ 114,116, 95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3880 */  48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77,
/* 0x3890 */  95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,
/* 0x38a0 */ 116, 97,114,116, 95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10,
/* 0x38b0 */  48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 84,
/* 0x38c0 */  72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108,
/* 0x38d0 */  95,115,116, 97,114,116, 95,111,102, 69, 76, 70, 77, 65, 73, 78,
/* 0x38e0 */  90, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 65, 82, 77,
/* 0x38f0 */  95, 84, 72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101,
/* 0x3900 */  97,108, 95,115,116, 97,114,116, 95,111,102, 69, 76, 70, 77, 65,
/* 0x3910 */  73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65,
/* 0x3920 */  82, 77, 95, 84, 72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,
/* 0x3930 */ 114,101, 97,108, 95,115,116, 97,114,116, 95,111,102, 69, 76, 70,
/* 0x3940 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82,
/* 0x3950 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3960 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x3970 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67, 65, 76,
/* 0x3980 */  76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,114,116,
/* 0x3990 */  95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48,
/* 0x39a0 */  48, 49, 49, 50, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77, 95, 67,
/* 0x39b0 */  65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,116, 97,
/* 0x39c0 */ 114,116, 95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x39d0 */  48, 48, 48, 49, 50, 97, 32, 82, 95, 65, 82, 77, 95, 84, 72, 77,
/* 0x39e0 */  95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108, 95,115,
/* 0x39f0 */ 116, 97,114,116, 95,111,102, 69, 76, 70, 77, 65, 73, 78, 90, 10,
/* 0x3a00 */  48, 48, 48, 48, 48, 49, 51, 52, 32, 82, 95, 65, 82, 77, 95, 84,
/* 0x3a10 */  72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101, 97,108,
/* 0x3a20 */  95,115,116, 97,114,116, 95,111,102, 69, 76, 70, 77, 65, 73, 78,
/* 0x3a30 */  90, 10, 48, 48, 48, 48, 48, 49, 51,101, 32, 82, 95, 65, 82, 77,
/* 0x3a40 */  95, 84, 72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,114,101,
/* 0x3a50 */  97,108, 95,115,116, 97,114,116, 95,111,102, 69, 76, 70, 77, 65,
/* 0x3a60 */  73, 78, 90, 10, 48, 48, 48, 48, 48, 49, 52, 54, 32, 82, 95, 65,
/* 0x3a70 */  82, 77, 95, 84, 72, 77, 95, 67, 65, 76, 76, 32, 32, 32, 32, 46,
/* 0x3a80 */ 114,101, 97,108, 95,115,116, 97,114,116, 95,111,102, 69, 76, 70,
/* 0x3a90 */  77, 65, 73, 78, 90, 10
};
